* ------------------------------------------------------------------------------
* - PCE deflator -
* ------------------------------------------------------------------------------

freduse DPCERG3A086NBEA,clear
rename DPCERG3A086NBEA pce_deflator
gen year = real(substr(date,1,4))
keep year pce_deflator 
lab var pce_deflator "PCE Index"
keep if year>=1960
tempfile pce
save `pce'


* ------------------------------------------------------------------------------
* - Merge with r* data provided by Lukas
* ------------------------------------------------------------------------------

import delimited "..\raw_data/figure_grr.csv",clear

keep v1 v10 
replace v1 = round(v1)

rename v1 year
rename v10 r_star

gcollapse(mean) r_star, by(year)

keep if year>=1960 & year<=2020

tempfile rstar
save `rstar', replace

* ------------------------------------------------------------------------------
* - Import and clean GRR data (2011) -
* ------------------------------------------------------------------------------

* import data
 import delimited "..\raw_data/GRR_usdata.csv", ///
 numericcols(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26) clear

* Generate quarterly date variable starting "1947-01-01"
gen date=tq(1947q1)+_n-1
format date %tq
lab var date "Date"
order date // Makes date first variable in dataset

* Returns: Business capital
rename returntobusinesscapitalaftertax grr_rk_bs_post
rename returntobusinesscapitalaftertaxn grr_rk_bs_post_noc

keep date grr_* 
gen year = yofd(dofq(date))

gcollapse (mean) grr_*, by(year)

keep if year>=1960
tsset year

* Adjust for average revaluation differences (for 1960 onwards)

* series with no revaluation
qui sum grr_rk_bs_post_noc 
local mean_noc = `r(mean)'

* series with revaluation
qui sum grr_rk_bs_post
local mean_wtc = `r(mean)'

gen grr_rk_bs_post_avgrev = grr_rk_bs_post_noc + (`mean_wtc' - `mean_noc')
gen grr_rk_bs_post_rev= grr_rk_bs_post-grr_rk_bs_post_noc

tempfile grr
save `grr', replace


* ------------------------------------------------------------------------------
* - Load and format IMA data for households -
* ------------------------------------------------------------------------------

import excel "../raw_data/IMA_Section1All_xls.xlsx", sheet("IMAtS3.a-A") cellrange(A8:BL157) clear

* - Extract firm observation year -
local start_year = real(C[1])
di `start_year'
keep if A!=""
sxpose,clear

* - Get names and labels from lines -
foreach var of varlist * {
	local stub = `var'[1]
	local description=`var'[2]
	
	rename `var' ima_hh_`stub'
	label variable ima_hh_`stub' "`description'"  
}

drop if _n == 1 | _n==2 | _n==3

* - Make numeric -
foreach var of varlist * {
	destring `var', force replace
	replace `var' = 0 if missing(`var')
}

rename ima_hh_Line	year

tempfile ima_hh
save `ima_hh', replace

* ------------------------------------------------------------------------------
* - Load and format IMA data for corporate sector -
* ------------------------------------------------------------------------------

import excel "..\raw_data/IMA_Section1All_xls.xlsx", sheet("IMAtS5.a-A") cellrange(A8:BL182) clear

* - Extract firm observation year -
local start_year = real(C[1])
di `start_year'
keep if A!=""
sxpose,clear

* - Get names and labels from lines -
foreach var of varlist * {
	local stub = `var'[1]
	local description=`var'[2]
	
	rename `var' ima_cc_`stub'
	label variable ima_cc_`stub' "`description'"  
}

drop if _n == 1 | _n==2 | _n==3

* - Make numeric -
foreach var of varlist * {
	destring `var', force replace
	replace `var' = 0 if missing(`var')
}

rename ima_cc_Line	year

tempfile ima_cc
save `ima_cc', replace

* ------------------------------------------------------------------------------
* - Corporate Capital Share from NIPA tables -
* ------------------------------------------------------------------------------

import excel     "..\raw_data/NIPA_Section1All_xls.xlsx", sheet("T11300-A") cellrange(A8:BX97) clear

keep if inlist(A,"Line","3","4","9")

drop B C

sxpose,clear

* - Get names from lines -
foreach var of varlist * {
	local stub = `var'[1]
	di "`stub'"
	rename `var' nipa1_`stub'
}

drop if _n == 1

foreach var of varlist * {
	destring `var', replace
}

rename nipa1_Line	year

tsset year

gen capital_share = 1 - nipa1_4/(nipa1_3 - nipa1_9)

lab var capital_share "Corporate Sector Capital Share (NIPA)"

keep year capital_share*

keep if year>=1960

tempfile nipa_capshare
save `nipa_capshare', replace


* ------------------------------------------------------------------------------
* - Load and format NIPA data -
* ------------------------------------------------------------------------------

import excel "..\raw_data/NIPA_Section2All_xls.xlsx", sheet("T20100-A") cellrange(A8:CQ54) clear

* - Extract firm observation year -
local start_year = real(C[1])
di `start_year'
keep if A!=""
sxpose,clear

* - Get names and labels from lines -
foreach var of varlist * {
	local stub = `var'[1]
	local description=`var'[2]
	
	rename `var' nipa_hh_`stub'
	label variable nipa_hh_`stub' "`description'"  
}

drop if _n == 1 | _n==2 | _n==3

* - Make numeric -
foreach var of varlist * {
	destring `var', force replace
	replace `var' = 0 if missing(`var')
}

rename nipa_hh_Line	year
keep if year>=1960
merge 1:1 year using `nipa_capshare', assert(3) nogenerate
merge 1:1 year using `ima_hh', assert(3) nogenerate
merge 1:1 year using `ima_cc', assert(3) nogenerate
merge 1:1 year using `grr', assert(3) nogenerate
merge 1:1 year using `rstar', assert(2 3) nogenerate
merge 1:1 year using `pce', assert(2 3) keep (3) nogenerate
tsset year

* - Deflate variables using PCE ------------------------------------------------
foreach var of varlist nipa_* ima_* {
	replace `var' = `var' * 100/pce_deflator
}

* - Average Tax Rate ----------------------------------------------------------
gen avg_tax = nipa_hh_26/(nipa_hh_3 + nipa_hh_9 + nipa_hh_12 + nipa_hh_13)


********************************************************************************
*** CALCULATE RETURNS TO CAPITAL / EQUITY, AT MARKET/ BOOK VALUE, FROM HH/CC ***
********************************************************************************


* - Return 1: return to equity measured in market value from hh side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_eq_mv_hh=f.nipa_hh_15            			                 /* note: this is the same as ima_hh_17 */
gen v_eq_mv_hh=ima_hh_118+ima_hh_119  			                                 /* note: follows reviewer, but note that ima_hh_119 includes many bonds too. Their income is paid as dividednds, but this is not r_k either */
gen dv_eq_mv_hh=(f.ima_hh_90+f.ima_hh_91)/(ima_hh_118+ima_hh_119)  /* note: revaluation accounts captures change in nominal value from *holding* asset. in IMAs this is always done on the side of the owner of the asset */

* - Return 2: return to private buisness capital [book value, I believe] from hh side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_pk_bv_hh=f.nipa_hh_9*capital_share   /* note: this assumes that surpkus is 28.3% of gross income generated by business */
gen v_pk_bv_hh=ima_hh_121  			                  /* note: my understanding is that this is measures at book value (no market value available) */
gen dv_pk_bv_hh=f.ima_hh_92/ima_hh_121  /* note: revaluation accounts captures change in nominal value from *holding* asset. In this case, we have changes in book value */

* - Return 3: return to equity measured in market value from cc side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_eq_mv_cc=f.ima_cc_17             	 				/* note: this is dividends paid by US corporations */
gen v_eq_mv_cc=ima_cc_156  			     				/* note: this is the market value of the corporate sector */
gen dv_eq_mv_cc=(f.ima_cc_102+f.ima_cc_103)/ima_cc_156  /* note: revaluation accounts captures change in market value from household side of *holding* equity, which shows up in liability side of firms' revaluation account */

* - Return 4: return to capital (equity+bonds) measured in market value from cc side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_ck_mv_cc=f.ima_cc_15             	/* note: this is the total income paid in dividends or to creditors */
gen v_ck_mv_cc=ima_cc_144  			    /* note: this is the market value of total liabilities */
gen dv_ck_mv_cc=f.ima_cc_100/ima_cc_144 /* note: revaluation of firm liabilities (most of this is due to changes in equity price; debt and other liabilities have no revaluations) */

* - Return 5: return to equity measured in book value from cc side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_eq_bv_cc=f.ima_cc_17           				              /* note: this is dividends paid by US corporations */
gen v_eq_bv_cc=ima_cc_156+ima_cc_166  				              /* note: this is the book value of equity (equity+net worth...). Recall: assets of firms are book value; equity is market value; residual is net worth */
gen dv_eq_bv_cc=(f.ima_cc_88+f.ima_cc_93)/(ima_cc_156+ima_cc_166) /* note: revaluation accounts captures change in book value on firm assets. This is now in the asset side of revaluation account */

* - Return 6: return to capital (equity+bonds) measured in book value from cc side (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_ck_bv_cc=f.ima_cc_15             	             /* note: this is the total income paid in dividends or to creditors */
gen v_ck_bv_cc=ima_cc_108  			                 /* note: this is the book value of total liabilities=assets */
gen dv_ck_bv_cc=(f.ima_cc_88+f.ima_cc_93)/ima_cc_108 /* note: revaluation now on asset side */

* - Return 7: return to productive assets owned by the firm at book value (d=income flow; v=value; dv=revaluation; dpi=expected revaluation in percent terms)*
gen d_ckp_bv_cc=(f.ima_cc_10-f.ima_cc_21-f.ima_cc_22)  /* note: net operating surplus (does not include income from financial assets) */
gen v_ckp_bv_cc=ima_cc_109 			         	       /* note: this is the book value of productive assets */
gen dv_ckp_bv_cc=f.ima_cc_88/ima_cc_109 			   /* note: revaluation of productive assets on the asset side */

* - Average return -------------------------------------------------------------
gen d_ave_hh=(f.nipa_hh_15+f.nipa_hh_9*0.283)
gen v_ave_hh=ima_hh_118+ima_hh_119+ima_hh_121
gen dv_ave_hh=(f.ima_hh_90+f.ima_hh_91+f.ima_hh_92)/(ima_hh_118+ima_hh_119+ima_hh_121)

* expected returns *
*rangestat (mean) dv_*, interval(year -9 0) adaptive expectations
rangestat (mean) dv_*, interval(year 0 9) 
gen year_60=year-1960
foreach concept in eq_mv_hh pk_bv_hh eq_mv_cc eq_bv_cc ck_mv_cc ck_bv_cc ckp_bv_cc ave_hh{

gen rinc_`concept'=(1-f.avg_tax)*d_`concept'/v_`concept'*100
qui sum dv_`concept'
gen rmean_`concept'=((1-f.avg_tax)*d_`concept'/v_`concept'+(1-f.avg_tax)*`r(mean)')*100	
gen rexp_`concept'=((1-f.avg_tax)*d_`concept'/v_`concept'+(1-f.avg_tax)*dv_`concept'_mean)*100
gen rreal_`concept'=((1-f.avg_tax)*d_`concept'/v_`concept'+(1-f.avg_tax)*dv_`concept')*100
gen rev_`concept'=	((1-f.avg_tax)*dv_`concept')*100
} 

save "../clean_data/nipa_ima_clean.dta", replace


********************************************************************************
*** CALCULATE R_W BASED ON R_K ABOVE, R_STAR AND KAPPA FROM PORTFOLIO_SHARES.DO ***
********************************************************************************

* ------------------------------------------------------------------------------
* - Merge with growth rate data and portfolio shares-
* ------------------------------------------------------------------------------

import excel "../raw_data/US_trend_growth.xlsx", sheet("CBO Data") cellrange(A13:C86) clear firstrow
gen year=1959+_n
rename GDPPOT_POPTHM_ADJ grate
rename GDPPOT_POPTHM grate_noadj
keep year grate grate_noadj
tempfile growth
save `growth', replace

* MAKE SURE THIS FILE IS THE ONE THAT WAS GENERATED BY PORTFOLIO SHARES.DO 
use "../raw_data/dina_imanipa_dfa_data_v01.dta", clear 
tempfile returns
save `returns', replace

use "../clean_data/nipa_ima_clean.dta" , clear
merge 1:1 year using `returns', nogenerate
merge 1:1 year using `growth', nogenerate
*keep if year<=2021


* compute measures of returns * use GRR for r_K
gen rk_measure=grr_rk_bs_post_avgrev
gen rb_measure=r_star

* average returns adjusting for growth (smoothed) *
rangestat (mean) grate, interval(year -10 10) 
rangestat (mean) grate_noadj, interval(year -10 10) 

* adjusted r_K and r_B * 

gen rk_measure_adj  = rk_measure-grate_mean
gen rb_measure_adj  = rb_measure-grate_mean
gen rk_measure_adj2 = rk_measure-2*grate_mean
gen rb_measure_adj2 = rb_measure-2*grate_mean

* r_W measures *

gen rw_dfa_KI_cen                =(dfa_sh_KI_cen)*(rk_measure)+(1-dfa_sh_KI_cen)*(rb_measure)
gen rw_dfa_KI_cen_adj            =(dfa_sh_KI_cen)*(rk_measure-grate_mean)+(1-dfa_sh_KI_cen)*(rb_measure-grate_mean)
gen rw_dfa_KI_cen_adj2           =(dfa_sh_KI_cen)*(rk_measure-2*grate_mean)+(1-dfa_sh_KI_cen)*(rb_measure-2*grate_mean)

gen rw_dfa_KI_no_safe_cen        =(dfa_sh_nw_KI_no_safe_cen)*(rk_measure)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure)
gen rw_dfa_KI_no_safe_cen_adj    =(dfa_sh_nw_KI_no_safe_cen)*(rk_measure-grate_mean)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure-grate_mean)
gen rw_dfa_KI_no_safe_cen_adj2   =(dfa_sh_nw_KI_no_safe_cen)*(rk_measure-2*grate_mean)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure-2*grate_mean)

gen rw_dfa_nw_KI_cen             =(dfa_sh_nw_KI_cen)*(rk_measure)+(1-dfa_sh_nw_KI_cen)*(rb_measure)
gen rw_dfa_nw_KI_cen_adj         =(dfa_sh_nw_KI_cen)*(rk_measure-grate_mean)+(1-dfa_sh_nw_KI_cen)*(rb_measure-grate_mean)
gen rw_dfa_nw_KI_cen_adj2        =(dfa_sh_nw_KI_cen)*(rk_measure-2*grate_mean)+(1-dfa_sh_nw_KI_cen)*(rb_measure-2*grate_mean)

gen rw_dfa_nw_KI_no_safe_cen     =(dfa_sh_nw_KI_no_safe_cen)*(rk_measure)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure)
gen rw_dfa_nw_KI_no_safe_cen_adj =(dfa_sh_nw_KI_no_safe_cen)*(rk_measure-grate_mean)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure-grate_mean)
gen rw_dfa_nw_KI_no_safe_cen_adj2=(dfa_sh_nw_KI_no_safe_cen)*(rk_measure-2*grate_mean)+(1-dfa_sh_nw_KI_no_safe_cen)*(rb_measure-2*grate_mean)

gen rw_dina_KI_cen               =(dina_sh_KI_cen)*(rk_measure)+(1-dina_sh_KI_cen)*(rb_measure)
gen rw_dina_KI_cen_adj           =(dina_sh_KI_cen)*(rk_measure-grate_mean)+(1-dina_sh_KI_cen)*(rb_measure-grate_mean)
gen rw_dina_KI_cen_adj2          =(dina_sh_KI_cen)*(rk_measure-2*grate_mean)+(1-dina_sh_KI_cen)*(rb_measure-2*grate_mean)

gen rw_dina_KI_no_safe_cen       =(dina_sh_KI_no_safe_cen)*(rk_measure)+(1-dina_sh_KI_no_safe_cen)*(rb_measure)
gen rw_dina_KI_no_safe_cen_adj   =(dina_sh_KI_no_safe_cen)*(rk_measure-grate_mean)+(1-dina_sh_KI_no_safe_cen)*(rb_measure-grate_mean)
gen rw_dina_KI_no_safe_cen_adj2  =(dina_sh_KI_no_safe_cen)*(rk_measure-2*grate_mean)+(1-dina_sh_KI_no_safe_cen)*(rb_measure-2*grate_mean)

gen rw_benchmark                 =(1+imanipa_sh_deb2equ)*(rk_measure)+(1-(1+imanipa_sh_deb2equ))*(rb_measure)
gen rw_benchmark_adj             =(1+imanipa_sh_deb2equ)*(rk_measure-grate_mean)+(1-(1+imanipa_sh_deb2equ))*(rb_measure-grate_mean)
gen rw_benchmark_adj2            =(1+imanipa_sh_deb2equ)*(rk_measure-2*grate_mean)+(1-(1+imanipa_sh_deb2equ))*(rb_measure-2*grate_mean)

drop ima* nipa* 

export delimited "../clean_data/returns.csv", replace




/*



* figure 1
tsline r_star grr_rk_bs_post_avgrev rmean_ckp_bv_cc rmean_pk_bv_hh 

* figure 2
tsline grr_rk_bs_post_noc rinc_ckp_bv_cc rinc_pk_bv_hh 
tsline grr_rk_bs_post_rev rev_ckp_bv_cc rev_pk_bv_hh

* fig 3 three panels
tsline rmean_eq_mv_hh rmean_eq_mv_cc rmean_ave_hh
tsline rexp_eq_mv_hh rexp_eq_mv_cc rexp_ave_hh
tsline rreal_eq_mv_hh rreal_eq_mv_cc rreal_ave_hh



/* note sum(pi_eq_hh) should look like S&P 500. It has similar features but not exactly the same.
gen equity_index=sum( pi_eq_hh)
tsline equity_index

* note: retained earnings important for levels, but no trend...
gen share_payments=ima_cc_15/(ima_cc_24+ima_cc_15)
gen share_dividednd=ima_cc_17/(ima_cc_24+ima_cc_17)
tsline share_*
*/


gen Q=ima_cc_156/(ima_cc_156 +ima_cc_166)
tsline Q



*/

